<?php   
if( $category ){	
	$numberposts = (int)$numberposts;
	$class_col_lg = ($columns == 5) ? '2-4'  : (12/$columns);
	$class_col_md = ($columns1 == 5) ? '2-4'  : (12/$columns1);
	$class_col_sm = ($columns2 == 5) ? '2-4'  : (12/$columns2);
	$class_col_xs = ($columns3 == 5) ? '2-4'  : (12/$columns3);
	$class_col = 'col-xl-'.$class_col_lg .' col-lg-'.$class_col_md .' col-md-'.$class_col_sm .' col-'.$class_col_xs; 	
	$cat_selected = '';
	$widget_id = 'tab_category_'.rand().time();	
?>
<div class="bwp-filter-homepage tab-category <?php echo esc_attr($layout); ?>" <?php if($style_product > 1) { ?>data-content_product="<?php echo esc_attr($style_product) ?>"<?php } ?> data-class_col = "<?php echo esc_attr($class_col); ?>" data-numberposts = "<?php echo esc_attr($numberposts); ?>">
	<div class="bwp-filter-heading">
		<div class="category-tab-nav">
			<?php if(isset($title1) && $title1) { ?>
				<div class="title-block">
					<h2><?php echo esc_html($title1); ?></h2>
				</div>
			<?php } ?>
			<ul class="filter-category">
				<?php
				foreach($category as $key => $cat){	?>
					<?php
					$term = get_term_by('slug', $cat, 'product_cat');
					?>
					<?php if($cat == 'all'){?>
						<li class="category <?php if( ( $key + 1 ) == 1 ){echo 'active'; $cat_selected = $cat;}?>" data-value="<?php echo esc_attr($cat); ?>">
							<a href="#<?php echo esc_attr($widget_id).'_' . $cat; ?>" data-toggle="tab">
								<?php echo esc_html__( "All", 'wpbingo'); ?>
							</a>
						</li>
					<?php }else{?>
						<?php $terms = get_term_by('slug', $cat, 'product_cat');
						if($terms) : ?>
						<li class="category <?php if( ( $key + 1 ) == 1 ){echo 'active'; $cat_selected = $cat;}?>" data-value="<?php echo esc_attr($cat); ?>">					
							<a class="name-category" href="#<?php echo esc_attr($widget_id).'_'. $cat; ?>" data-toggle="tab">
								<?php echo esc_html($terms->name); ?>
							</a>
						</li>
						<?php endif; ?>
					<?php }?>
				<?php } ?>
			</ul>
		</div>
	</div>
	<div class="bwp-filter-content">
		<?php
		$args = array(
			'post_type' 			=> 'product',
			'post_status' 			=> 'publish',
			'posts_per_page' 		=> $numberposts,	
		);
		$tax_query = array();
		if($cat_selected != 'all'){
			$tax_query[] = array(
							'taxonomy'	=> 'product_cat',
							'field'		=> 'slug',
							'terms'		=> $cat_selected );
		}
		$meta_query = array();
		switch ($select_order) {
			case 'date':
				$args['orderby']	= 'date';
			break;
			case 'rating':
				add_filter( 'posts_clauses',  'order_by_rating_post_clauses'  );				
			break;
			case 'popularity':
				$args['meta_key']	= 'total_sales';
				$args['orderby']	= 'meta_value_num';
			break;
			case 'featured':
				$product_visibility_term_ids = wc_get_product_visibility_term_ids();
				$tax_query[] = 	array(
									'taxonomy' => 'product_visibility',
									'field'    => 'term_taxonomy_id',
									'terms'    => $product_visibility_term_ids['featured'],
								);			
			break;
		}	
		$args['tax_query'] = $tax_query;
		$args['meta_query'] = $meta_query;
		$list = new WP_Query( $args );
		?>
		<ul class="filter-orderby hidden">	  
			<li data-value="<?php echo esc_attr($select_order); ?>" class="active"><?php echo esc_html($select_order); ?></li>
		</ul>
		<div class="content-product-list content-products-<?php echo esc_attr($cat_selected); ?>">
			<div class="content products-list grid row">
				<?php while($list->have_posts()): $list->the_post();
					global $product, $post, $wpdb, $average; ?>
					<div class="item <?php echo $class_col; ?>">
						<div class="item-product">
							<?php include(WPBINGO_ELEMENTOR_TEMPLATE_PATH.'content-product.php'); ?>
						</div>
					</div>
				<?php endwhile; wp_reset_postdata();?>
			</div>
		</div>
		<div class="content-banner-image">
			<div class="banner-product-homepage">
				<div class="image-banner-product">
					<a href="<?php echo esc_url($link_button);?>"><img class="banner-product" src="<?php echo esc_url($banner['url']); ?>" alt="<?php echo esc_attr__("Banner Image","wpbingo"); ?>"></a>
				</div>
				<div class="banner-wrapper-infor">
					<div class="content-info">
						<?php if( $description) : ?>
							<div class="description">
								<?php if(isset($description) && $description){?>						
									<?php echo $editor_content; ?>						
								<?php }?>
							</div>	
						<?php endif;?>
						<?php if($label_button): ?>
							<a class="button bwp-align-icon-<?php echo esc_attr($icon_align);?>" href="<?php echo esc_url($link_button);?>">
								<span class="bwp-button-text"><?php echo ($label_button); ?></span>
								<?php if ( ! empty( $settings['icon'] ) || ! empty( $settings['selected_icon']['value'] ) ) : ?>
									<div class="bwp-button-icon">
										<?php
											if ( $is_new || $migrated ) {
												Icons_Manager::render_icon( $icon_svg );
											} else {
												echo '<i class="' . esc_attr( $icon ) . '" aria-hidden="true"></i>';
											}
										?>
									</div>
								<?php endif; ?>
							</a>						
						<?php endif;?>
					</div>
				</div>
			</div>
		</div>
	</div>	
</div>
<?php } ?>