<?php 
	$delor_settings = delor_global_settings();
	$cart_layout = delor_get_config('cart-layout','dropdown');
	$cart_style = delor_get_config('cart-style','light');
	$show_minicart = get_theme_mod('icon_cart_1', true);
	$show_searchform = get_theme_mod('search_form_1', true);
	$show_wishlist = get_theme_mod('icon_wishlist_1', true);
	$show_account = get_theme_mod('icon_account_1', true);
	$sticky_header = (isset($delor_settings['enable-sticky-header']) && $delor_settings['enable-sticky-header']) ? ($delor_settings['enable-sticky-header']) : false;
	if(get_theme_mod('topbar_order_1')){
		$arr_topbar_order = explode("-", get_theme_mod('topbar_order_1', ''));
	}else{
		$arr_topbar_order = explode("-", "topbar1-topbar3");
	}
	if(get_theme_mod('header_order_1')){
		$header_order_1   = get_theme_mod('header_order_1', '');
		$arr_header_order = explode("-", get_theme_mod('header_order_1', ''));
	}else{
		$header_order_1   = 'logo-menu-page_link';
		$arr_header_order =  explode("-", "logo-menu-page_link");
	}
?>
<h1 class="bwp-title hide"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
<header id='bwp-header' class="bwp-header header-v1">
	<?php delor_campbar(); ?>
	<?php if(get_theme_mod('top_bar_1', false)) { ?>
		<div id="bwp-topbar" class="topbar-v1<?php if(!get_theme_mod('topbar_mobile','')) { ?> hidden-sm hidden-xs<?php } ?>">
			<div class="topbar-inner">
				<div class="container">
					<div class="topbar-container">
						<?php foreach ($arr_topbar_order as $value) { 
							switch ($value) {
							case 'topbar1': ?>
								<?php if(get_theme_mod('content_left_top_bar_1', 'Summer Sale Discount 50% Off.')) { ?>
									<div class="topbar-left">
										<?php echo get_theme_mod('content_left_top_bar_1', 'Summer Sale Discount 50% Off.'); ?>
									</div>
								<?php } ?>
							<?php break;
							case 'topbar2': ?>
								<?php if(get_theme_mod('content_center_top_bar_1', 'content topbar 3')) { ?>
									<div class="topbar-center">
										<?php echo get_theme_mod('content_center_top_bar_1', 'content topbar 3'); ?>
									</div>
								<?php } ?>
							<?php break;
							case 'topbar3': ?>
								<div class="topbar-right contact">
									<div class="phone hidden-xs"><a href="tel:<?php echo get_theme_mod('phone_topbar_1', '+1800 354 4321') ?>"><i class="icon-call"></i><?php echo get_theme_mod('phone_topbar_1', '+1800 354 4321') ?></a></div>
									<div class="email"><a href="mailto:<?php echo get_theme_mod('email_topbar_1', 'support@delor.com') ?>"><i class="icon-email"></i><?php echo get_theme_mod('email_topbar_1', 'support@delor.com') ?></a></div>
								</div>
							<?php break;
							case 'social': ?>
								<?php if(get_theme_mod('social_1', '') && shortcode_exists("social_link")) { ?>
									<div class="social-link_topbar">
										<?php echo do_shortcode ("[social_link]") ?>
									</div>
								<?php } ?>
							<?php break; default: ?>
							<?php } ?>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>
	<?php delor_menu_mobile(); ?>
	<div class="header-desktop">
		<div class='header-wrapper' data-sticky_header="<?php echo esc_attr($delor_settings['enable-sticky-header']); ?>">
			<div class="container">
				<div class="header-container <?php echo esc_attr($header_order_1) ?>">
					<?php foreach ($arr_header_order as $value) {
						switch ($value) {
							case 'logo': ?>
								<div class="header-logo <?php echo get_theme_mod('logo_pos_1', 'text-left'); ?>">
									<?php delor_header_logo(); ?>
								</div>
							<?php break;
							case 'menu': ?>
								<div class="header-menu <?php echo get_theme_mod('menu_pos_1', 'menu-center'); ?>">
									<div class="wpbingo-menu-mobile">
										<div class="header-menu-bg">
											<?php delor_top_menu(); ?>
										</div>
									</div>
								</div>
							<?php break;
							case 'page_link': ?>
								<?php if(($show_account || $show_minicart || $show_wishlist || is_active_sidebar('top-link')) && class_exists( 'WooCommerce' ) ){ ?>
									<div class="header-searchform-icon">
										<div class="header-page-link <?php echo get_theme_mod('icon_pos_1', 'text-right'); ?>">
											<!-- Begin Search -->
											<?php if($show_searchform){ ?>
												<div class="header-search-form hidden-sm hidden-xs">
													<?php if(class_exists( 'WooCommerce' )){ ?>
														<?php get_template_part( 'search-form' ); ?>
													<?php } ?>
												</div>
											<?php } ?>
											<!-- End Search -->
											<?php if($show_account){ ?>
												<div class="login-header">
													<?php if (is_user_logged_in()) { 
														$current_user = get_user_by('id', get_current_user_id()); ?>
														<a class="active-login" href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>">
															<span class="wp-tools-inner">
																<span class="wp-tools-text"><?php echo 'سلام / ' . $current_user->user_login; ?></span>
															</span>
														</a>
														<div class="wp-dropdown-my-account">
															<ul>
																<?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
																	<li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
																		<a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
																	</li>
																<?php endforeach; ?>
															</ul>
														</div>
													<?php } else { ?>
														<a class="active-login" href="#">
															<span class="wp-tools-inner">
																<span class="wp-tools-text"><?php echo esc_html__('login / register', 'delor')?></span>
															</span>
														</a>
														<?php if ( !is_account_page() ) {delor_login_form();}
													} ?>
												</div>
											<?php } ?>
											<?php if($show_wishlist && class_exists( 'WPCleverWoosw' )){ ?>
											<div class="wishlist-box">
												<a href="<?php echo WPcleverWoosw::get_url(); ?>">
													<i class="icon-wishlist"></i>
													<span class="count-wishlist"><?php echo WPcleverWoosw::get_count(); ?></span>
												</a>
											</div>
											<?php } ?>
											<?php if($show_minicart && class_exists( 'WooCommerce' )){ ?>
												<div class="remove-cart-shadow"></div>
												<div class="delor-topcart delor-topcart-desktop <?php echo esc_attr($cart_layout); ?> <?php echo esc_attr($cart_style); ?>">
													<?php get_template_part( 'woocommerce/minicart-ajax' ); ?>
												</div>
											<?php } ?>
										</div>
									</div>
								<?php } ?>
							<?php break; default: ?>
						<?php } ?>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</header><!-- End #bwp-header -->